<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSubjectsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('subjects', function (Blueprint $table) {
            $table->id();
            $table->string('surname');
            $table->string('firstname');
            $table->string('othername')->nullable();
            $table->string('class')->nullable();
            $table->string('teacher_id')->unique();
            $table->string('password');
            $table->set('sex', ['Male', 'Female'])->nullable();
            $table->set('marital', ['Single', 'Married', 'Divorced'])->nullable();
            $table->string('phone')->nullable();
            $table->string('phone2')->nullable();
            $table->longText('address')->nullable();
            $table->string('email')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('subjects');
    }
}
