<?php

namespace Illuminate\Support\Facades;

interface Auth
{
    /**
     * @return \App\Models\F_login|false
     */
    public static function loginUsingId(mixed $id, bool $remember = false);

    /**
     * @return \App\Models\F_login|false
     */
    public static function onceUsingId(mixed $id);

    /**
     * @return \App\Models\F_login|null
     */
    public static function getUser();

    /**
     * @return \App\Models\F_login
     */
    public static function authenticate();

    /**
     * @return \App\Models\F_login|null
     */
    public static function user();

    /**
     * @return \App\Models\F_login|null
     */
    public static function logoutOtherDevices(string $password);

    /**
     * @return \App\Models\F_login
     */
    public static function getLastAttempted();
}