<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Dashboard') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl grid gap-x-8 md:grid-cols-3 mx-auto sm:px-6 lg:px-8">
            <div class="bg-green-700 flex my-4 mx-8 justify-between px-10 py-10 overflow-hidden shadow-sm sm:rounded-lg hover:scale-110 transition duration-300 ease-in-out">
                <div class="text-sm text-white w-1/2">
                    Create and Update Bills
                    <p class="text-xs italic">Bills for all levels</p>
                </div>
                <a href="{{route('bills')}}" class="bg-transparent h-12 w-28 hover:bg-white text-white font-semibold hover:text-green-700 py-2 px-4 border border-white hover:border-transparent rounded">
                    Click here
                </a>
            </div>

            <div class="bg-green-700 flex my-4 mx-8 justify-between px-10 py-10 overflow-hidden shadow-sm sm:rounded-lg hover:scale-110 transition duration-300 ease-in-out">
                <div class="text-sm text-white w-1/2">
                    Defaulters
                    <p class="text-xs italic">Check and print the list of defaulters</p>
                </div>
                <a href="{{route('defaulters')}}" class="bg-transparent h-12 w-28 hover:bg-white text-white font-semibold hover:text-green-700 py-2 px-4 border border-white hover:border-transparent rounded">
                    Click here
                </a>
            </div>

            <div class="bg-green-700 flex my-4 mx-8 justify-between px-10 py-10 overflow-hidden shadow-sm sm:rounded-lg hover:scale-110 transition duration-300 ease-in-out">
                <div class="text-sm text-white w-1/2">
                    Payroll
                    <p class="text-xs italic">Create Payroll for Teachers and Send Schedules</p>
                </div>
                <a href="{{ route("payroll") }}" class="bg-transparent h-12 w-28 hover:bg-white text-white font-semibold hover:text-green-700 py-2 px-4 border border-white hover:border-transparent rounded">
                    Click here
                </a>
            </div>

            <div class="bg-green-700 flex my-4 mx-8 justify-between px-10 py-10 overflow-hidden shadow-sm sm:rounded-lg hover:scale-110 transition duration-300 ease-in-out">
                <div class="text-sm text-white w-1/2">
                    Payment Analysis
                    <p class="text-xs italic">Check all the payment analysis.</p>
                </div>
                <a href="{{ route("payments") }}" class="bg-transparent h-12 w-28 hover:bg-white text-white font-semibold hover:text-green-700 py-2 px-4 border border-white hover:border-transparent rounded">
                    Click here
                </a>
            </div>

            <div class="bg-green-700 flex my-4 mx-8 justify-between px-10 py-10 overflow-hidden shadow-sm sm:rounded-lg hover:scale-110 transition duration-300 ease-in-out">
                <div class="text-sm text-white w-1/2">
                    Approve Bank Transfer
                    <p class="text-xs italic">Check all the bank transfer.</p>
                </div>
                <a href="{{ route('bank-transfer') }}" class="bg-transparent h-12 w-28 hover:bg-white text-white font-semibold hover:text-green-700 py-2 px-4 border border-white hover:border-transparent rounded">
                    Click here
                </a>
            </div>

        </div>
    </div>
</x-app-layout>
