<x-app-layout>

    <!---Modal -->
    <div class="fixed hidden insert-0 bg-opacity-50 overflow-y-auto h-screen w-screen top-2 z-10" id="modal">
        <div class="relative top-20 mx-auto px-5 border w-1/2 shadow-lg rounded-md bg-white">
            <div class="text-left">
                <div class="max-w-xl p-5 mx-auto my-10 bg-white rounded-md shadow-sm">
                    <div class="text-center">
                      <h1 class="my-3 text-xl font-semibold text-gray-700">Create a Bill</h1>
                      <p class="text-gray-400">Fill up the form below to create a bill.</p>
                    </div>
                    <div>
                      <form class="mt-4" action="{{route('school-fees-create')}}" method="POST">
                        @csrf
                        <div class="flex gap-2">
                            <div class="mb-6 w-1/2">
                                <div class="mb-6">
                                    <label class="inline-block text-sm text-gray-600" for="color">Select Term</label>
                                    <div class="relative flex w-full py-1">
                                        <select required name="term" class="block w-full py-2 pl-4 pr-8 bg-white border border-gray-300 rounded-sm appearance-none cursor-pointer focus:outline-none hover:border-gray-400">
                                            <option disabled selected>Select Term</option>
                                            <option>First</option>
                                            <option>Second</option>
                                            <option>Third</option>
                                        </select>
                                        <div class="absolute inset-y-0 right-0 flex items-center px-2 text-green-400 pointer-events-none">
                                        <svg class="w-6 h-6 fill-current" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20">
                                            <path d="M9.293 12.95l.707.707L15.657 8l-1.414-1.414L10 10.828 5.757 6.586 4.343 8z"></path>
                                        </svg>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="mb-6 w-1/2">
                                <label for="name" class="block mb-2 text-sm text-gray-600"
                                    >Session</label
                                >
                                <input
                                    type="text"
                                    name="session"
                                    placeholder="2023/2024"
                                    required
                                    class="w-full px-3 py-2 placeholder-gray-300 border border-gray-300 rounded-md  focus:outline-none focus:ring focus:ring-green-100 focus:border-green-300"
                                />
                            </div>
                        </div>
                        <div class="mb-6">
                          <button
                            type="submit"
                            class="w-full px-2 py-4 text-white bg-green-500 rounded-md  focus:bg-green-600 focus:outline-none"
                          >
                            Create Bills
                          </button>
                        </div>

                        <div class="items-center mb-6">
                            <button id="ok-btn" class="px-2 py-4 bg-red-500 text-white
                                            text-base font-medium rounded-md w-full
                                            shadow-sm hover:bg-red-600 focus:outline-none focus:ring-2 focus:ring-red-300">
                                Close
                            </button>

                        </div>
                      </form>
                    </div>
                  </div>
            </div>

        </div>
    </div>

    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Bill Options/School Fees') }}
        </h2>
    </x-slot>

    <div class="container mx-auto">
        <div class="p-5 mx-auto my-10 bg-white rounded-md shadow-sm">
            <div class="flex justify-between px-10">
                <div class="text-left">
                    <h3 class="font-semibold text-2xl py-2 text-gray-800 leading-tight">School Fees Bills</h3>
                </div>
                <div class="">
                    <button class="px-4 py-4 text-white bg-green-500 rounded-md  focus:bg-green-600 focus:outline-none" id="open-btn">
                        + Add new bill
                    </button>
                </div>
            </div>

            {{-- Filter List start --}}
            <div class="flex justify-center px-10">
                <form class="w-full px-10" action="{{ route("school-fees-query") }}" method="GET">
                    <div class="flex justify-center gap-4">
                        <div class="mb-6 w-1/3">
                            <div class="mb-6">
                                <label class="inline-block text-sm text-gray-600" for="color">Select Term</label>
                                <div class="relative flex w-full py-1">
                                    <select required name="term" class="block w-full py-2 pl-4 pr-8 bg-white border border-gray-300 rounded-md appearance-none cursor-pointer focus:outline-none hover:border-gray-400">
                                        <option disabled selected>Select Term</option>
                                        <option>First</option>
                                        <option>Second</option>
                                        <option>Third</option>
                                    </select>
                                    <div class="absolute inset-y-0 right-0 flex items-center px-2 text-green-400 pointer-events-none">
                                    <svg class="w-6 h-6 fill-current" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20">
                                        <path d="M9.293 12.95l.707.707L15.657 8l-1.414-1.414L10 10.828 5.757 6.586 4.343 8z"></path>
                                    </svg>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="mb-6 w-1/3">
                            <label for="name" class="block mb-2 text-sm text-gray-600"
                                >Session</label
                            >
                            <input
                                type="text"
                                name="session"
                                placeholder="2023/2024"
                                required
                                class="w-full px-3 py-2 placeholder-gray-300 border border-gray-300 rounded-md  focus:outline-none focus:ring focus:ring-green-100 focus:border-green-300"
                            />
                        </div>

                        <div class="mb-6 pt-6 mt-1 w-1/3">
                            <button
                              type="submit"
                              class="w-full px-2 py-2 text-white bg-green-500 rounded-md  focus:bg-green-600 focus:outline-none"
                            >
                              Filter
                            </button>
                        </div>
                    </div>
                </form>
            </div>
            {{-- Filter List ends --}}

            {{-- List starts --}}
            <div class="max-w-7xl grid gap-x-8 md:grid-cols-2 mx-auto sm:px-6 lg:px-8">
                @if ($all != null)
                    @foreach ($all as $bill)
                        <div class="bg-white @if($bill->tuition == null || $bill->others == null || $bill->pta == null || $bill->entryfee == null) border-red-700 @else border-green-700 @endif border-2 my-4 mx-8 px-1 py-3 overflow-hidden shadow-sm sm:rounded-lg hover:scale-105 transition duration-300 ease-in-out">
                            <div class="text-black w-full my-2 py-2 px-4">
                                <h3 class="text-xl font-extrabold">{{$bill->class}} Bill</h3>

                                <p class="text-md font-semibold">{{$bill->term}} term, {{$bill->session}}</p>
                                <table class="w-full text-left border-collapse border border-slate-500">
                                    <thead>
                                      <tr class="py-2 px-4 font-semibold">
                                        <th class="border border-slate-500">Options</th>
                                        <th class="border border-slate-500">Cost (&#8358)</th>
                                      </tr>
                                    </thead>
                                    <tbody>
                                      <tr class="py-2 px-4">
                                        <td class="border border-slate-500">Tuition</td>
                                        <td class="border border-slate-500">{{ $bill->tuition }}</td>
                                      </tr>
                                      <tr class="py-2 px-4">
                                        <td class="border border-slate-500">Others</td>
                                        <td class="border border-slate-500">{{ $bill->others }}</td>
                                      </tr>
                                      <tr class="py-2 px-4">
                                        <td class="border border-slate-500">PTA</td>
                                        <td class="border border-slate-500">{{ $bill->pta }}</td>
                                      </tr>
                                      <tr class="py-2 px-4">
                                        <td class="border border-slate-500">Entry Fee</td>
                                        <td class="border border-slate-500">{{ $bill->entryfee }}</td>
                                      </tr>
                                      <tr class="py-2 px-4">
                                        <td class="border border-slate-500">Lesson Fee</td>
                                        <td class="border border-slate-500">{{ $bill->lessonfee }}</td>
                                      </tr>
                                      <tr class="py-2 px-4">
                                        <td class="border border-slate-500">Val/Prize Giving</td>
                                        <td class="border border-slate-500">{{ $bill->valedictoryfee }}</td>
                                      </tr>
                                    </tbody>
                                </table>

                                <div class="mt-4 justify-center flex">
                                    <form action="{{ route('school-fees-update') }}" method="POST">
                                        @csrf
                                        <input type="text" name="id" value="{{ $bill->id }}" hidden>
                                        <button type="submit" class="bg-green-700 text-center h-12 w-full hover:bg-white text-white font-semibold hover:text-green-700 py-2 px-4 border border-white hover:border-green-700 rounded-lg">
                                            Update Bill
                                        </button>
                                    </form>
                                </div>
                            </div>

                        </div>
                    @endforeach
                @endif
            </div>
            {{-- List ends --}}
        </div>
    </div>


    <script>
        let modal = document.getElementById('modal');
        let btn = document.getElementById('open-btn');
        let button = document.getElementById('ok-btn');

        btn.onclick = function () {
            modal.style.display = 'block';
        };

        button.onclick = function () {
            modal.style.display = 'none';
        };

        window.onclick = function (event) {
            if (event.target == modal) {
                modal.style.display = "none";
            }
        }

    </script>
</x-app-layout>


