<x-app-layout>
    @php
        $surname = DB::table("students")->where("id", Auth::id())->first()->surname;
        $firstname = DB::table("students")->where("id", Auth::id())->first()->firstname;
        $reg_no = DB::table("students")->where("id", Auth::id())->first()->reg_no;
    @endphp
<style>
    input[type="radio"]:checked + span {
        display: block;
    }
</style>

    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Transactions') }}
        </h2>
    </x-slot>

    <div class="container mx-auto">
        <div class="p-5 mx-auto my-10 bg-white rounded-md shadow-sm">
            <div class="flex justify-between px-10">
                <div class="text-left">
                    <h3 class="font-semibold text-2xl py-2 text-gray-800 leading-tight">{{ $page }}</h3>
                </div>

                <div class="flex gap-2">
                    <div class="">
                        <a href="{{ route("transactions") }}">
                            <button class="px-4 py-4 text-white bg-blue-500 rounded-md  hover:bg-blue-700 focus:outline-none">
                                All
                            </button>
                        </a>
                    </div>
                    <div class="">
                        <a href="{{ route("approved-transactions") }}">
                            <button class="px-4 py-4 text-white bg-green-500 rounded-md  hover:bg-green-700 focus:outline-none">
                                Approved
                            </button>
                        </a>
                    </div>
                    <div class="">
                        <a href="{{ route("pending-transactions") }}">
                            <button class="px-4 py-4 text-white bg-yellow-500 rounded-md  hover:bg-yellow-700 focus:outline-none">
                                Pending
                            </button>
                        </a>
                    </div>
                    <div class="">
                        <a href="{{ route("failed-transactions") }}">
                            <button class="px-4 py-4 text-white bg-red-500 rounded-md  hover:bg-red-700 focus:outline-none">
                                Failed
                            </button>
                        </a>
                    </div>
                </div>

            </div>


            {{-- transactions list starts --}}
            <div class="w-full mt-12 py-2 px-4 text-xl">
                    <div class="text-black text-left w-full my-2 py-2 px-4">
                        <p class="text-xl font-semibold">Name: {{$surname}} {{$firstname}}</p>
                        <p class="text-xl font-semibold">Reg_no: {{$reg_no}}</p>
                        <table class="w-full text-left border-collapse border border-slate-500">
                            <thead>
                              <tr class="py-2 px-4 font-semibold">
                                <th class="border border-slate-500">S/N</th>
                                <th class="border border-slate-500">Time</th>
                                <th class="border border-slate-500">Details</th>
                                <th class="border border-slate-500">Reference</th>
                                <th class="border border-slate-500">Amount</th>
                                <th class="border border-slate-500">Status</th>
                                <th class="border border-slate-500"></th>
                              </tr>
                            </thead>
                            <tbody>
                                @php
                                    $i = 0;
                                @endphp
                                @foreach ($bank as $transaction)
                                    <tr class="py-2 px-4">
                                        <td class="border border-slate-500">{{ $i = $i + 1 }}</td>
                                        <td class="border border-slate-500">{{ $transaction->created_at }}</td>
                                        <td class="border border-slate-500">{{ $transaction->details }}</td>
                                        <td class="border border-slate-500">{{ $transaction->reference }}</td>
                                        <td class="border border-slate-500">{{ $transaction->amount }}</td>
                                        <td class="border border-slate-500">{{ $transaction->status }}</td>
                                        <td class="border border-slate-500">
                                            @if($transaction->status == 'success')
                                                <form action="" method="post">
                                                    <input type="text" value="{{ $transaction->id }}" hidden>
                                                    <button type="submit" class="px-4 py-4 text-white bg-blue-500 rounded-md  hover:bg-blue-700 focus:outline-none">
                                                        Change Status
                                                    </button>
                                                </form>
                                            @endif
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>


                    </div>


            </div>
            {{-- transactions list ends --}}
        </div>


    </div>

</x-app-layout>


