<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('billoptions', function (Blueprint $table) {
            $table->id();
            $table->string("class");
            $table->string("term");
            $table->string("session");
            $table->bigInteger("tuition")->nullable();
            $table->bigInteger("pta")->nullable();
            $table->bigInteger("others")->nullable();
            $table->bigInteger("lessonfee")->nullable();
            $table->bigInteger("valedictoryfee")->nullable();
            $table->bigInteger("entryfee")->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('billoptions');
    }
};
