<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Student;
use App\Models\StudentStatus;
use RealRashid\SweetAlert\Facades\Alert;

class DefaultersController extends Controller
{
    public function index(){
        $students = Student::all();
        foreach($students as $student){
            //Check if it has been registered
            if(StudentStatus::where('reg_no', $student->reg_no)->first() == null){
                StudentStatus::create([
                    'reg_no' => $student->reg_no
                ]);
            }
        }

        $statuses = StudentStatus::all();
        Alert::toast("All Students status list", "success");
        return view('defaulters.index', ["statuses" => $statuses]);
    }

    public function clearedIndex(){
        $students = Student::all();
        foreach($students as $student){
            //Check if it has been registered
            if(!StudentStatus::where('reg_no', $student->reg_no)){
                StudentStatus::create([
                    'reg_no' => $student->reg_no
                ]);
            }
        }

        $statuses = StudentStatus::where("status", "cleared")->get();
        Alert::toast("Cleared Students status list", "success");
        return view('defaulters.index', ["statuses" => $statuses]);
    }

    public function defaultingIndex(){
        $students = Student::all();
        foreach($students as $student){
            //Check if it has been registered
            if(!StudentStatus::where('reg_no', $student->reg_no)){
                StudentStatus::create([
                    'reg_no' => $student->reg_no
                ]);
            }
        }

        $statuses = StudentStatus::where("status", "defaulting")->get();
        Alert::toast("Defaulting Students status list", "success");
        return view('defaulters.index', ["statuses" => $statuses]);
    }

    public function changeStatus(Request $request){
        $status = StudentStatus::find($request->id);
        if($status->status == 'cleared'){
            StudentStatus::where("id", $request->id)
            ->update([
                'status' => 'defaulting'
            ]);
        }else{
            StudentStatus::where("id", $request->id)
            ->update([
                'status' => 'cleared'
            ]);
        }
        $status = StudentStatus::find($request->id);
        Alert::toast($status->reg_no." Status changed to ".$status->status, "success");
        return redirect()->route("defaulters");
    }
}
