

<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8">
    
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title>Upload Results</title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

    <!-- Scripts -->
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
</head>

<body class="font-sans antialiased">
    <?php echo $__env->make('sweetalert::alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php

    ?>

    <div class="flex justify-center mt-8">
        <div class="w-full mt-12 py-2 px-4 text-xl">
            <div class="flex my-4">
                <div class="w-full flex justify-between">
                    <div>
                        <?php if (isset($component)) { $__componentOriginal8892e718f3d0d7a916180885c6f012e7 = $component; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.application-logo','data' => ['class' => 'w-30 h-20 fill-current text-gray-500']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('application-logo'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'w-30 h-20 fill-current text-gray-500']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal8892e718f3d0d7a916180885c6f012e7)): ?>
<?php $component = $__componentOriginal8892e718f3d0d7a916180885c6f012e7; ?>
<?php unset($__componentOriginal8892e718f3d0d7a916180885c6f012e7); ?>
<?php endif; ?>
                    </div>
                    <div>
                        <h2 class="text-xl font-bold">
                            OAKFIELD SCHOOLS
                        </h2>
                        <h4 class="text-sm italic">Nursery, Primary and Secondary</h4>
                        <h4 class="text-sm ">ORIMERUNMU ROAD, ORIMERUNMU, OGUN STATE</h4>
                        <h4 class="text-sm italic">The Preferred....</h4>
                    </div>
                </div>
            </div>
            <div class="text-black text-center w-full my-2 py-2 px-4">
                <h3 class="text-xl font-extrabold"><?php echo e($results->first()->session); ?>, <?php echo e($results->first()->term); ?> Term
                    Results</h3>
                <table class="w-full text-left border-collapse border border-slate-500 text-sm">
                    <thead>
                        <tr class="py-2 px-4 font-semibold">
                            <th class="border border-slate-500" colspan="2">Subject: <?php echo e($results->first()->subject); ?>

                            </th>
                            <th class="border border-slate-500" colspan="2">Class: <?php echo e($results->first()->class); ?>

                            </th>
                        </tr>

                    </thead>
                </table>
                <table class="w-full my-4 text-left border-collapse border border-slate-500">
                    <thead>
                        <tr class="py-2 px-4 font-semibold text-sm">
                            <th class="border border-slate-500">S/N</th>
                            <th class="border border-slate-500">Name</th>
                            <th class="border border-slate-500">Reg_no</th>
                            <th class="border border-slate-500">Test(10)</th>
                            <th class="border border-slate-500">CA(30)</th>
                            <th class="border border-slate-500">Total(40)</th>

                        </tr>
                    </thead>
                    <form action="<?php echo e(route('upload-query-post')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <tbody>
                            <?php
                                $i = 0;
                            ?>
                            <?php $__currentLoopData = $results; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $record): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr class="py-2 px-4 text-sm">
                                    <td class="border border-slate-500"><?php echo e($i = $i + 1); ?></td>
                                    <td class="border border-slate-500">
                                        <?php echo e(DB::table('students')->where('reg_no', $record->reg_no)->first()->surname); ?>

                                        <?php echo e(DB::table('students')->where('reg_no', $record->reg_no)->first()->firstname); ?>

                                    </td>
                                    <td class="border border-slate-500 text-green-700"><?php echo e($record->reg_no); ?></td>
                                    <td class="border border-slate-500">
                                        <input name="records[]" type="text" value="<?php echo e($record->id); ?>" hidden>
                                        <input type="number" class="border-2 border-green-500" name="records[]"
                                            id="" value="<?php echo e($record->at); ?>" max="10">
                                    </td>
                                    <td class="border border-slate-500">
                                        <input type="number" class="border-2 border-green-500" name="records[]"
                                            id="" value="<?php echo e($record->ex); ?>" max="30">
                                    </td>
                                    <td class="border border-slate-500 font-semibold text-lg">
                                        <?php echo e($record->ts); ?>

                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            <tr class="py-2 px-4 text-sm">
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td>
                                    <button type="submit"
                                        class="w-full px-2 py-4 text-white bg-green-500 rounded-md  focus:bg-green-600 focus:outline-none">
                                        Upload
                                    </button>
                                </td>
                            </tr>

                        </tbody>
                    </form>
                </table>

                <div class="flex justify-between">
                    <table class="w-3/6 my-4 text-left border-collapse border border-slate-500 text-sm font-semibold">
                        <tbody>

                            <tr class="py-2 px-4 text-sm">
                                <td class="border border-slate-500 w-1/3">Teacher's Name: </td>
                                <td class="border border-slate-500">
                                    <?php echo e(DB::table('subjects')->where('id', Auth::id())->first()->surname); ?>

                                    <?php echo e(DB::table('subjects')->where('id', Auth::id())->first()->firstname); ?><br>
                                    <?php echo e(DB::table('subjects')->where('id', Auth::id())->first()->teacher_id); ?>


                                </td>
                            </tr>
                        </tbody>
                    </table>

                    <div>
                        <small class="italic">created by tic atelier</small>
                    </div>
                </div>
            </div>

        </div>
    </div>

</body>

</html>
<?php /**PATH C:\Users\user\Desktop\Desktop\Projects\academic-portal\resources\views/result/upload.blade.php ENDPATH**/ ?>