<x-app-layout>
    <style>
        input[type="radio"]:checked+span {
            display: block;
        }
    </style>

    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Question Bank') }}
        </h2>
    </x-slot>

    <div class="container mx-auto">
        <div class="p-5 mx-auto my-10 bg-white rounded-md shadow-sm">
            <div class="flex justify-between px-10">
                <div class="flex w-full justify-start">
                    <a href="{{ route('dashboard') }}">
                        <button class="px-4 py-4 text-white bg-red-500 rounded-md  hover:bg-red-600 hover:outline-none">
                            <- Dashboard </button>
                    </a>
                </div>



            </div>


            {{-- Invoice starts --}}
            <div class="w-full mt-12 py-2 px-4 text-xl">
                <div class="text-black text-center w-full my-2 py-2 px-4">
                    <h3 class="text-2xl font-extrabold">{{ $data['subject'] }} - {{ $data['term'] }} -
                        {{ $data['class'] }}</h3>
                        <p class="text-sm text-center text-gray-800">{{ $questions->count() }} Questions Uploaded</p>


                    <div class="flex justify-between gap-8">

                        <div class="md:w-1/2 p-5 mx-auto my-10 bg-white rounded-md shadow-sm">
                            <div class="text-center">
                                <h1 class="my-3 text-3xl font-semibold text-gray-700">{{ 'Add New' }}</h1>
                                <p class="text-gray-400">Fill in the correct details</p>
                            </div>
                            <div>
                                <form class="mt-8" action="{{ route('cbt-questions-store') }}" method="POST">
                                    @csrf
                                    <input name="subject" value="{{ $data['subject'] }}" type="hidden">
                                    <input name="term" value="{{ $data['term'] }}" type="hidden">
                                    <input name="class" value="{{ $data['class'] }}" type="hidden">
                                    <div class="mb-6">
                                        <label class="inline-block text-sm text-gray-600"
                                            for="color">Question</label>
                                        <!-- Include Quill stylesheet -->
                                        <link href="https://cdn.quilljs.com/1.0.0/quill.snow.css" rel="stylesheet">

                                        <div class="relative w-full">
                                            <textarea name="question" type="hidden" id="questionText"
                                                class="quilljs-textarea block w-full py-3 pl-4 pr-8 bg-white border border-gray-300 rounded-sm appearance-none cursor-pointer focus:outline-none hover:border-gray-400"> </textarea>
                                        </div>
                                    </div>

                                    <div class="flex gap-2">
                                        <div class="mb-6">
                                            <label class="inline-block text-sm text-gray-600" for="color">Option
                                                A</label>
                                            <div class="relative flex w-full">
                                                <input name="option1" type="text"
                                                    class="block w-full py-3 pl-4 pr-8 bg-white border border-gray-300 rounded-sm appearance-none cursor-pointer focus:outline-none hover:border-gray-400"
                                                    placeholder="">

                                            </div>
                                        </div>

                                        <div class="mb-6">
                                            <label class="inline-block text-sm text-gray-600" for="color">Option
                                                B</label>
                                            <div class="relative flex w-full">
                                                <input name="option2" type="text"
                                                    class="block w-full py-3 pl-4 pr-8 bg-white border border-gray-300 rounded-sm appearance-none cursor-pointer focus:outline-none hover:border-gray-400"
                                                    placeholder="">

                                            </div>
                                        </div>

                                        <div class="mb-6">
                                            <label class="inline-block text-sm text-gray-600" for="color">Option
                                                C</label>
                                            <div class="relative flex w-full">
                                                <input name="option3" type="text"
                                                    class="block w-full py-3 pl-4 pr-8 bg-white border border-gray-300 rounded-sm appearance-none cursor-pointer focus:outline-none hover:border-gray-400"
                                                    placeholder="">

                                            </div>
                                        </div>

                                        <div class="mb-6">
                                            <label class="inline-block text-sm text-gray-600" for="color">Option
                                                D</label>
                                            <div class="relative flex w-full">
                                                <input name="option4" type="text"
                                                    class="block w-full py-3 pl-4 pr-8 bg-white border border-gray-300 rounded-sm appearance-none cursor-pointer focus:outline-none hover:border-gray-400"
                                                    placeholder="">

                                            </div>
                                        </div>
                                    </div>

                                    <div class="flex justify-between gap-2">
                                        <div class="mb-6">
                                            <label class="inline-block text-sm text-gray-600" for="color">Correct
                                                Answer</label>
                                            <div class="relative flex w-full">
                                                <input name="correct_option" type="text"
                                                    class="block w-full py-3 pl-4 pr-8 bg-white border border-gray-300 rounded-sm appearance-none cursor-pointer focus:outline-none hover:border-gray-400"
                                                    placeholder="">

                                            </div>
                                        </div>

                                        <div class="mb-6">
                                            <label class="inline-block text-sm text-gray-600"
                                                for="color">Topic</label>
                                            <div class="relative flex w-full">
                                                <input name="topic" type="text"
                                                    class="block w-full py-3 pl-4 pr-8 bg-white border border-gray-300 rounded-sm appearance-none cursor-pointer focus:outline-none hover:border-gray-400"
                                                    value="@if ($questions->first() != null) {{ $questions->first()->topic }} @endif">

                                            </div>
                                        </div>
                                    </div>

                                    <div class="mb-6">
                                        <button type="submit"
                                            class="w-full px-2 py-4 text-white bg-green-500 rounded-md  focus:bg-green-600 focus:outline-none">
                                            Add
                                        </button>
                                    </div>
                                </form>
                                @if ($errors->any())
                                    @foreach ($errors->all() as $error)
                                        <div class="h-32 w-full bg-red-300 text-black py-8 px-2">{{ $error }}
                                        </div>
                                    @endforeach
                                @endif
                            </div>
                        </div>


                        <div class="md:w-1/2 p-5 mx-auto my-10">
                            <h4 class="text-2xl font-bold text-center">Questions</h4>

                            @forelse ($questions as $question)
                                <!-- Question -->
                                <div class="mb-6 px-2 py-4 bg-green-500 text-sm rounded-lg">
                                    <div class="text-sm font-semibold text-gray-800 mb-4">
                                        @php echo $question->question @endphp
                                    </div>

                                    <!-- Options -->
                                    <div class="space-y-3">
                                        <label
                                            class="flex items-center p-3 border border-gray-200 rounded-lg hover:bg-gray-50 cursor-pointer transition">
                                            <span class="ml-3 text-gray-700">A. {{ $question->option1 }}</span>
                                        </label>

                                        <label
                                            class="flex items-center p-3 border border-gray-200 rounded-lg hover:bg-gray-50 cursor-pointer transition">
                                            <span class="ml-3 text-gray-700">B. {{ $question->option2 }}</span>
                                        </label>

                                        <label
                                            class="flex items-center p-3 border border-gray-200 rounded-lg hover:bg-gray-50 cursor-pointer transition">
                                            <span class="ml-3 text-gray-700">C. {{ $question->option3 }}</span>
                                        </label>

                                        <label
                                            class="flex items-center p-3 border border-gray-200 rounded-lg hover:bg-gray-50 cursor-pointer transition">
                                            <span class="ml-3 text-gray-700">D. {{ $question->option4 }}</span>
                                        </label>
                                    </div>
                                    <p>Correct Answer = {{ $question->correct_option }}</p>

                                    <!-- Action Buttons -->
                                    <div class="flex gap-3 text-sm justify-end border-t border-gray-200 pt-4">
                                        <button
                                            class="flex items-center gap-2 px-4 py-2 text-gray-700 bg-gray-100 rounded-lg hover:bg-gray-200 transition">
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor"
                                                viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z" />
                                            </svg>
                                            Edit
                                        </button>

                                        <button
                                            class="flex items-center gap-2 px-4 py-2 text-white bg-red-500 rounded-lg hover:bg-red-600 transition">
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor"
                                                viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16" />
                                            </svg>
                                            Delete
                                        </button>
                                    </div>

                                </div>
                            @empty
                                <p class="text-xl">No Questions Uploaded Yet....</p>
                            @endforelse
                        </div>
                    </div>



                </div>

            </div>
            {{-- Invoice ends --}}
        </div>


    </div>

    <!-- Include the Quill library -->
    <script src="https://cdn.quilljs.com/1.0.0/quill.js"></script>
    <script src="{{asset("js/quill-textarea.js")}}"></script>

    <!-- Initialize Quill editor -->
    <script>
    (function() {
      quilljs_textarea('.quilljs-textarea', {
        modules: { toolbar: [
          ['bold', 'italic', 'underline'],        // toggled buttons
          [{ 'list': 'ordered'}, { 'list': 'bullet' }, { 'list': 'check' }],
          [{ 'script': 'sub'}, { 'script': 'super' }],      // superscript/subscript
          [{ 'indent': '-1'}, { 'indent': '+1' }],          // outdent/indent
          [{ 'direction': 'rtl' }],                         // text direction

          [{ 'header': [1, 2, 3, 4, 5, 6, false] }],
          [{ 'color': [] }, { 'background': [] }],          // dropdown with defaults from theme
          [{ 'align': [] }],
        ]},
        theme: 'snow',
      });
    })();
    </script>

    <script>
        function myFunction() {
            // Declare variables
            var input, filter, table, tr, td, i, txtValue;
            input = document.getElementById("myInput");
            filter = input.value.toUpperCase();
            table = document.getElementById("myTable");
            tr = table.getElementsByTagName("tr");

            // Loop through all table rows, and hide those who don't match the search query
            for (i = 0; i < tr.length; i++) {
                td = tr[i].getElementsByTagName("td")[1];
                if (td) {
                    txtValue = td.textContent || td.innerText;
                    if (txtValue.toUpperCase().indexOf(filter) > -1) {
                        tr[i].style.display = "";
                    } else {
                        tr[i].style.display = "none";
                    }
                }
            }
        }
    </script>


    <script>
        let modal = document.getElementById('modal');
        let btn = document.getElementById('open-btn');
        let button = document.getElementById('ok-btn');

        btn.onclick = function() {
            modal.style.display = 'block';
        };

        button.onclick = function() {
            modal.style.display = 'none';
        };

        window.onclick = function(event) {
            if (event.target == modal) {
                modal.style.display = "none";
            }
        }
    </script>
</x-app-layout>
