<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('students', function (Blueprint $table) {
            $table->id();
            $table->string('surname');
            $table->string('firstname');
            $table->string('othername')->nullable();
            $table->string('reg_no')->unique();
            $table->string('status')->default('active');
            $table->date('DoB')->nullable();
            $table->string('sex')->nullable();
            $table->string('state_of_origin')->nullable();
            $table->string('class');
            $table->string('level')->nullable();
            $table->string('dept')->nullable();
            $table->string('password');
            $table->string('class_on_admission')->nullable();
            $table->string('nationality')->nullable();
            $table->string('religion')->nullable();
            $table->bigInteger('parent_id')->nullable();
            $table->string('image')->nullable();
            $table->string('uploaded_by');
            $table->longText('address')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('students');
    }
};
